// stackTriangle2.java
// Program wyznacza liczby trjktne, wykorzystujc stos a nie rekurencj
// Aby uruchomi program: C>java StackTriangle2App
import java.io.*;              // konieczne do operacji wejcia/wyjcia
////////////////////////////////////////////////////////////////
class StackX
   {
   private int maxSize;        // wielko tablicy stosu
   private int[] stackArray;
   private int top;            // wierzchoek stosu
//--------------------------------------------------------------
   public StackX(int s)        // konstruktor
      {
      maxSize = s;
      stackArray = new int[maxSize];
      top = -1;
      }
//--------------------------------------------------------------
   public void push(int p)     // umieszczenie elementu na wierzchoku stosu
      { stackArray[++top] = p; }
//--------------------------------------------------------------
   public int pop()            // pobranie elementu z wierzchoka stosu
      { return stackArray[top--]; }
//--------------------------------------------------------------
   public int peek()           // odczytanie wartoci elementu z wierzchoka 
      { return stackArray[top]; }
//--------------------------------------------------------------
   public boolean isEmpty()    // true jeli stos jest pusty
      { return (top == -1); }
//--------------------------------------------------------------
   }  // koniec klasy StackX
////////////////////////////////////////////////////////////////
class StackTriangle2App
   {
   static int theNumber;
   static int theAnswer;
   static StackX theStack;

   public static void main(String[] args) throws IOException
      {
      System.out.print("Podaj liczbe: ");
      System.out.flush();
      theNumber = getInt();
      stackTriangle();
      System.out.println("Odpowiadajaca jej liczba trojkatna="+theAnswer);
      }  // end main()
//-------------------------------------------------------------
   public static void stackTriangle()
      {
      theStack = new StackX(10000);    // stworzenie stosu

      theAnswer = 0;                   // inicjalizacja wartoci wynikowej

      while(theNumber > 0)             // a do momentu gdy n wynosi 1
         {
         theStack.push(theNumber);     // zapis na stosie 
         --theNumber;                  // dekrementacja liczby
         }
      while( !theStack.isEmpty() )     // a do momentu gdy stos jest pusty,
         {
         int newN = theStack.pop();    // pobranie wartoci,
         theAnswer += newN;            // dodanie wartoci do odpowiedzi
         }
      }
//-------------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
//-------------------------------------------------------------
   public static int getInt() throws IOException
      {
      String s = getString();
      return Integer.parseInt(s);
      }
//--------------------------------------------------------------
   }  // koniec klasy StackTriangle2App
////////////////////////////////////////////////////////////////
